/** JPong - A Cambridge University Game Design Society Example

    Original code by : Gordon Williams (http://www.rabidhamster.org)

    This is probably not the best example of good coding, but it does work, and hopefully
    its not too bad to understand.
*/

// Import the Java classes that we need...
import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class JPong extends Applet implements Runnable,MouseListener, MouseMotionListener 
{
    /** the size of the window we'll be playing pong in */
    final static int SCRSIZE = 384; 
    /** the middle of the window we'll be playing pong in */
    final static int SCRMID = 192; 
    
    /** bat sizes */
    final static int BATWIDTH = 80; 
    final static int BATHALF = 40; 

    /** ball sizes */
    final static int BALLRAD = 10;

    /** speed of reaction of computer  eg. its handicap. Make this big and it'll whip you :) */
    final static int COMPSPEED = 30;
    /** the amount of effect the speed of the bat has on the speed of the ball */
    final static float BALLIMPACT = 0.05f; 

    /** The double-buffer. We draw onto this first, and then when we're finished
        we draw it to the window - It stops flicker */
	Image Buffer = null;

    /** the position of the bats */
    float userBatPos;
    float compBatPos;
    /** bat velocity - used for changing the ball speed */
    float userBatVel;
    float compBatVel;
    /** where the bats want to be... */
    float userBatPull;  
    float compBatPull;
    /** the position of the ball */
    float ballX;
    float ballY;
    /** the velocity of the ball */
    float ballVX ;
    float ballVY;
    /** The scores! */
    int userScore = 0;
    int compScore = 0;

    /** The Timer - this is used to draw a frame every 50th of a second  */
    Thread timer;

    /** This is called when the applet starts up */
    public void init() {
        // Ask Java to tell us when someone moves or clicks the mouse
		addMouseListener(this);
		addMouseMotionListener(this);
        // Create the double-buffer
		Buffer = this.createImage(SCRSIZE,SCRSIZE);
        // reset all the stuff for the game
        gameReset();
    }

    /** This is called in a seperate thread, and it tries to draw one frame every 50th of a second */
	public void run() {
        // run the garbage collector - this just cleans stuff up and hopefully
        // stops it from running when the game is running
		System.gc();
        // Keep going around this loop until we want to stop the applet
        while (timer != null)
		{
            // draw a frame
			gameFrame();
            // sleep for 1/50th of a second - so we get around 50fps hopefully
            try {  Thread.currentThread().sleep(20);
            } catch (InterruptedException e) { timer=null; }
        }
    }

    /** Called when animation wants to start in the applet */
  	public void start()
    {
        // Start a new thread to draw frames
        timer = new Thread(this);
		timer.setPriority(Thread.MIN_PRIORITY);
        timer.start();
    }

    /** Called when animation is supposed to stop */
    public void stop() {
        // signal the 'run' thread to stop
        timer = null;
    }

    /** Called every frame */
    void gameFrame() {
        // move the ball
        ballX += ballVX;
        ballY += ballVY;
        // Find out where we want to move the computer bat too
        // The dumb thing would be to set compBatPull=ballX;
        // but the code below guesses at where the ball will end up from its 
        // current position and velocity
        float c = (ballX-(ballY*ballVX/ballVY)) - BALLRAD; // work out the position
        float w = SCRSIZE - (BALLRAD*2); // width of screen the ball can move in
        while ((c<0) || (c>w)) {    // bounce the ball off the walls
            if (c<0) c = -c;
            if (c>w) c = w-(c-w);
        }
        compBatPull = c+BALLRAD;
        // move the bats to where they want to be
        userBatVel *= 0.7;                      // friction
        userBatVel += userBatPull-userBatPos;   // work out the difference in velocity
        userBatPos += userBatVel*0.125;          // move the bat by the velocity

        compBatVel *= 0.7;                      // friction
        compBatVel += compBatPull-compBatPos;   // work out difference in velocity
        if (compBatVel>COMPSPEED) compBatVel = COMPSPEED; // stop the bat moving too quickly
        if (compBatVel<-COMPSPEED) compBatVel = -COMPSPEED;
        compBatPos += compBatVel*0.125;          // move the bat
        // bounce the ball off the sides of the screen
        if ((ballX<BALLRAD) && (ballVX<0)) ballVX = -ballVX;
        if ((ballX>SCRSIZE-BALLRAD) && (ballVX>0)) ballVX = -ballVX;
        // try and bounce the ball off the user's bat
        if ((ballX+BALLRAD>userBatPos-BATHALF) && (ballX-BALLRAD<userBatPos+BATHALF) && (ballY+BALLRAD>SCRSIZE-10) && (ballVY>0)) {
            ballVY = -ballVY;
            ballVX += userBatVel*BALLIMPACT;
        }
        // bounce off computer's bat
        if ((ballX+BALLRAD>compBatPos-BATHALF) && (ballX-BALLRAD<compBatPos+BATHALF) && (ballY-BALLRAD<10) && (ballVY<0)) {
            ballVY = -ballVY;
            ballVX += compBatVel*BALLIMPACT;
        }
        // detect the ball going off the end...
        if ((ballY-BALLRAD<0) && (ballVY<0)) { userScore++; gameReset(); }
        if ((ballY+BALLRAD>SCRSIZE) && (ballVY>0)) { compScore++; gameReset(); }
        // update the screen
        paint(getGraphics());
    }

    /** Called when the game should reset */
    void gameReset() {
        // put bats in the middle of the screen
        compBatPos = SCRMID;
        compBatPull = SCRMID;
        compBatVel = 0;
        userBatPos = SCRMID;
        userBatPull = SCRMID;
        userBatVel = 0;
        // put ball in the middle
        ballX = SCRMID;
        ballY = SCRMID;
        // set up the ball velocity.
        do {
            double angle = Math.random()*2.0*3.141592; // get a random direction
            // use the direction to set up a ball with constant velocity
            ballVX = (float)(Math.sin(angle)*5.0);
            ballVY = (float)(Math.cos(angle)*5.0);
            // keep doing it until its moving up or down at a sensible speed
            // (we don't want it stuck in the middle)
        } while (Math.abs(ballVY)<3.0);
    }

    /** Called when what is on the screen needs to be updated */
    public void paint(Graphics g) 
	{
		Graphics gl = Buffer.getGraphics();
        // clear the buffer
		gl.setColor(Color.WHITE);
		gl.fillRect(0,0,SCRSIZE,SCRSIZE);
        // draw some text...
        gl.setColor(Color.GRAY);
        gl.drawString("CU Game Design Society",10,SCRMID);
        gl.drawString("--= Pong =--",10,SCRMID+15);
        gl.drawString("COMPUTER : "+compScore,10,SCRMID+30);
        gl.drawString("PLAYER : "+userScore,10,SCRMID+45);
        // draw the bats
        gl.setColor(Color.BLACK);
		gl.fillRect((int)userBatPos-BATHALF,SCRSIZE-10,BATWIDTH,10); // User's bat
        gl.fillRect((int)compBatPos-BATHALF,0,BATWIDTH,10); // Computer's bat
        // draw the Ball
        gl.setColor(Color.BLUE);
		gl.fillRect((int)ballX-BALLRAD,(int)ballY-BALLRAD,BALLRAD*2,BALLRAD*2);
        // draw a border
        gl.setColor(Color.GRAY);
        gl.drawRect(0,0,SCRSIZE-1,SCRSIZE-1);
        // draw the double-buffer to the screen
        g.drawImage(Buffer,0,0,SCRSIZE,SCRSIZE,this);
	}


    /* Mouse Methods - these are executed when the user does something with the mouse */
    public void mouseDragged(MouseEvent e) { }
    public void mouseMoved(MouseEvent e) {
        // set where we want to be to where the mouse is currently pointing
        userBatPull = e.getX();
    }
    public void mousePressed(MouseEvent e) { }
    public void mouseReleased(MouseEvent e) { }
    public void mouseEntered(MouseEvent e) { }
    public void mouseExited(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { }
}
