import java.applet.*;
import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class R2eRemote extends Applet implements Runnable, MouseListener
{
    Thread timer;                
    Socket Telnet;
    String CurrentLine = "";
    String IPAddress = null;
    String PIN = null;
	int Port = 23;
	int SqX = 64;
    int SqY = 64;

    Image Map = null;

    public void init()
    {
        addMouseListener(this);

		try
		{
			IPAddress = getProperty("address", "127.0.0.1");
			Port = getIntegerProperty("port", 23);
			PIN = getProperty("pin", "1234");
			SqX = getIntegerProperty("x", 64);
			SqY = getIntegerProperty("y", 64);
			Map = getImageProperty("mapfilename", "Map.jpg");

			Telnet = new Socket(IPAddress, Port);
			sendCommand(PIN);
        }
		catch (Exception e)
		{
			System.out.println("CRAP.. The init screwed up");
			System.err.println(e);
		}
    }

    public void sendCommand(String St)
    {
       try {
        OutputStream WCh = Telnet.getOutputStream();
        for (int i=0;i<St.length();i++)
         WCh.write(St.charAt(i));
        WCh.write(13);
       } catch (Exception e) { System.out.println("! Could not send Command...");};
    }

    public void onTimer()
    {
        if (Telnet==null) return;

        try {
         InputStream S = Telnet.getInputStream();
         int x=-1;
         while ((x=S.read())>=0)
         {
           CurrentLine = CurrentLine + (char)x;
           switch (x) {
           case 8 : CurrentLine = CurrentLine.substring(0,CurrentLine.length()-1);
                    break;
           case 13 :
                    System.out.print(CurrentLine);
                    CurrentLine="";
                    break; 
           }
         }
        } catch (IOException e) {};
    }

    public void paint(Graphics g)
    {
		if (Map != null)
		{
			Dimension size = getSize();
			g.drawImage(Map, 0, 0, size.width, size.height, this);
		}
    }

  	public void start() {
        // Initialise the Timer
        timer = new Thread(this);
        timer.start();
    }

    public void stop() {
        timer = null;
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (timer == me) {
            // Perform call check
            onTimer();
            // Wait for 1/10 second
            try { Thread.currentThread().sleep(100); }
             catch (InterruptedException e) { }
        }
    }

    public void mousePressed(MouseEvent e) {
		int x = e.getX()/SqX;
        int y = e.getY()/SqY;
        e.consume();
        String Cmd = null;
        Cmd = getProperty(x+"x"+y);
        if (Cmd!=null) sendCommand(Cmd);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
		
    }

	// Added by Rob Saunders 26/07/2002
	//
	// Some helper functions added to allow R2eRemote to run as a stand-alone
	// application as well as an applet. Includes some common property handling
	// routines, proper image loading (using MediaTracker), and a main() function
	// that creates a window.

	// A flag to determine whether this is running as an applet or not
	private boolean applet = true;

	// A store for properties local from a local file
	static private Properties properties;
	
	// When run as an application make sure that the right minimum and preferred
	// sizes are returned. If this isn't done the window will collapse to nothing
	// on start-up.

	public Dimension getMinimumSize()
	{
		if (applet) return super.getMinimumSize();
		else return getPreferredSize();
	}
	
	public Dimension getPreferredSize()
	{
		if (applet) return super.getPreferredSize();
		else return new Dimension(getIntegerProperty("width", 512), getIntegerProperty("height", 512));
	}

	// Some methods that will retrieve properties either from the HTML or properties
	// file depending on whether this is running as an applet or an application

	private String getProperty(String name)
	{
		if (applet) return getParameter(name);
		return properties.getProperty(name);
	}
	
	private String getProperty(String name, String default_value)
	{
		String value = getProperty(name);
		if (value == null) value = default_value;
		System.err.println(name+"="+value);
		return value.trim();
	}

	private int getIntegerProperty(String name, int default_value)
	{
		return parseIntegerString(getProperty(name), default_value);
	}

	private Image getImageProperty(String name, String default_filename)
	{
		String filename = getProperty(name);
		if (filename == null) filename = default_filename;
		return loadImage(filename);
	}

	private int parseIntegerString(String value_string, int default_value)
	{
		int return_value = default_value;
		if (value_string != null)
			try { return_value = Integer.parseInt(value_string); }
			catch (Exception e) { System.err.println(e); }
		return return_value;
	}

	// An method that will load an image either from a remote location or from a
	// local file depending on whether this is running as an applet or application

	private Image loadImage(String filename)
	{
		MediaTracker tracker = new MediaTracker(this);
		Image image = null;

		if (applet)
			try { image = this.getImage(new URL(getDocumentBase(), filename)); }
			catch (MalformedURLException e) { System.err.println(e); }
		else image = getToolkit().getImage(filename);

		if (image != null)
		{
			tracker.addImage(image, 0);
			try { tracker.waitForAll(); } catch (InterruptedException e) { System.err.println(e); }
		}

		return image;
	}

	// The applications main routine: loads a property file, creates a frame,
	// initialises the applet and displays the frame.
	
	static public void main(String[] args)
	{
		R2eRemote r2r = new R2eRemote();
		r2r.applet = false;
		
		try
		{
			FileInputStream fis = new FileInputStream("R2eRemote.properties");
			properties = new Properties();
			properties.load(fis);
		}
		catch (IOException e) { System.err.println(e); }

		r2r.init();

		Frame frame = new Frame("R2eRemote");
		frame.addWindowListener(new WindowAdapter() { public void windowClosing(WindowEvent e) {System.exit(0); } } );

		frame.setLayout(new FlowLayout(FlowLayout.CENTER, 0, 0));
		frame.add(r2r);
		frame.pack();
		frame.setVisible(true);

		r2r.start();
	}
}
